﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.RegularExpressions;
using System.Collections;

namespace QuickDecodeForCSharp
{


    ///调用示例
    ///string mingwen = "123321";
    ///string key = "45499207657641340430891962713637";
    ///string encodeStr = QuickEncrypt.encode(mingwen, key);
    ///string decodeStr = QuickEncrypt.decode(encodeStr, key);
    class QuickEncrypt
    {


        /// <summary>
        /// QuickSDK 同步参数解码
        /// </summary>
        /// <param name="src">密文</param>
        /// <param name="key">callbackKey</param>
        /// <returns></returns>
        static public string decode(string src,string key){

            if (src == null || src.Length == 0)
            {
                return src;
            }

            string pattern = "\\d+";
            MatchCollection results = Regex.Matches(src, pattern);

            ArrayList list = new ArrayList();
            for (int i = 0; i < results.Count; i++)
            {
                try
                {
                    String group = results[i].ToString();
                    list.Add( (Object)group );
                }
                catch (Exception e)
                {
                    return src;
                }
            }

            if (list.Count > 0)
            {
                try
                {
                    byte[] data = new byte[list.Count];
                    byte[] keys = System.Text.Encoding.Default.GetBytes(key);

                    for (int i = 0; i < data.Length; i++)
                    {
                        data[i] = (byte)(Convert.ToInt32(list[i]) - (0xff & Convert.ToInt32(keys[i % keys.Length]))  );
                    }
                    return System.Text.Encoding.Default.GetString(data);
                }
                catch (Exception e)
                {
                    return src;
                }
            }
            else
            {
                return src;
            }
      
        }

        /// <summary>
        /// QuickSDK 同步参数编码
        /// </summary>
        /// <param name="src">密文</param>
        /// <param name="key">callbackKey</param>
        /// <returns></returns>
        static public string encode(string src, string key) {

            try
            {
                byte[] data = System.Text.Encoding.Default.GetBytes(src);
                byte[] keys = System.Text.Encoding.Default.GetBytes(key);

                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < data.Length; i++)
                {
                    int n = (0xff & data[i]) + (0xff & keys[i % keys.Length]);
                    sb.Append("@" + n);
                }
                return sb.ToString();
            }
            catch (Exception e)
            {
                return src;
            }

        }
    }
}
